//+------------------------------------------------------------------+
//|                                         CA&PP_Chmura_MA_Full.mq4 |
//|                                                                  |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright ""
#property link ""
#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 clrDarkGreen
#property indicator_color2 clrRed
#property indicator_color3 clrYellow      
#property indicator_color4 clrDarkGreen
#property indicator_color5 clrRed
#property indicator_color6 clrYellow      
#property indicator_color7 clrDarkGreen
#property indicator_color8 clrRed

extern int MA1_Period=20;
extern ENUM_MA_METHOD MA1_Method = MODE_EMA;
extern ENUM_APPLIED_PRICE MA1_Price = PRICE_CLOSE;
extern int MA2_Period=40;
extern ENUM_MA_METHOD MA2_Method = MODE_EMA;
extern ENUM_APPLIED_PRICE MA2_Price = PRICE_CLOSE;
extern int MA_Width = 1;
extern int Cloud_Width = 1;
extern int Label_Window = 0;
extern int Label_Corner = 1;
extern color Label_NoTrade_Color = clrBlack;
extern color Label_Long_Color = clrDarkGreen;
extern color Label_Short_Color = clrRed;
extern string Label_Font_Type = "Tahoma";
extern int Label_Font_Size = 20;
extern int Label_X = 160;
extern int Label_Y = 80;
extern bool Label_By_MAs = true;
extern bool Label_By_Cloud_Color = true;
extern ENUM_TIMEFRAMES MTF_Master = PERIOD_CURRENT;
extern bool Plot_Cross_VLines = true;
extern ENUM_LINE_STYLE  VLines_STYLE = STYLE_DOT;
extern int  VLines_Width = 0;
extern bool VLines_Back = true;
extern bool save_globals = true;

double MA1, MA2;
double MA1_Buffer[], MA2_Buffer[];
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
int Period1, Period2;
string global_name_capp_trend;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
  //---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_DOT,Cloud_Width);
   SetIndexBuffer(0,MA1_Buffer);
   
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_DOT,Cloud_Width);
   SetIndexBuffer(1,MA2_Buffer);
   
   SetIndexBuffer(4,ExtMapBuffer1);
   SetIndexBuffer(3,ExtMapBuffer2);
   SetIndexBuffer(2,ExtMapBuffer3);
   
   SetIndexBuffer(7,ExtMapBuffer4);
   SetIndexBuffer(6,ExtMapBuffer5);
   SetIndexBuffer(5,ExtMapBuffer6);
   
   SetIndexStyle(4,DRAW_LINE,STYLE_SOLID,MA_Width);
   SetIndexStyle(3,DRAW_LINE,STYLE_SOLID,MA_Width);
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,MA_Width); 
     
   SetIndexStyle(7,DRAW_LINE,STYLE_SOLID,MA_Width);
   SetIndexStyle(6,DRAW_LINE,STYLE_SOLID,MA_Width);
   SetIndexStyle(5,DRAW_LINE,STYLE_SOLID,MA_Width);
   
   Period1=MA1_Period;
   Period2=MA2_Period;
   
   if(Period()<MTF_Master&&MTF_Master>PERIOD_CURRENT)
    {
    Period1=MA1_Period*MTF_Master/Period();
    Period2=MA2_Period*MTF_Master/Period();
    }
   for(int i=0; i<Bars; i++)
   {
   ObjectDelete(0,"CAPP_Cross"+(string)i);   
   }

   global_name_capp_trend="chmura_"+Symbol()+"_"+IntegerToString(Period());

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
  ObjectDelete (0,"CA&PP_Label_("+Period1+"/"+Period2+")");  
   
   for(int i=0; i<Bars; i++)
   {
   ObjectDelete(0,"CAPP_Cross"+(string)i);   
   }
   GlobalVariableDel(global_name_capp_trend);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {   
   if(IsNewBar())
    {
   for(int i=0; i<Bars; i++)
   {
   ObjectDelete(0,"CAPP_Cross"+(string)i);   
   }
    }
   
   int    counted_bars=IndicatorCounted();
   
   int limit=Bars-counted_bars;
   if(counted_bars>0) limit++;
   
   for(i=1; i<limit; i++)
   {
      MA1=iMA(NULL,0,Period1,0,MA1_Method,MA1_Price,i);
      MA2=iMA(NULL,0,Period2,0,MA2_Method,MA2_Price,i);
   
      MA1_Buffer[i]=MA1;
      MA2_Buffer[i]=MA2;
      
   }
//----  
   double MA1_Cur, MA1_Prev, MA2_Cur, MA2_Prev;
   counted_bars = IndicatorCounted();
   //---- check for possible errors
   if (counted_bars<0) return(-1);
   //---- last counted bar will be recounted
   if (counted_bars>0) counted_bars--;
   limit = Bars - counted_bars;
   
   for(i=limit; i>=0; i--)
   {
      if (MA1_Method == 4)
      {
        MA1_Cur = LSMA(Period1,i);
        MA1_Prev = LSMA(Period1,i+1);
      }
      else
      {
        MA1_Cur = iMA(NULL,0,Period1,0,MA1_Method,MA1_Price,i);
        MA1_Prev = iMA(NULL,0,Period1,0,MA1_Method,MA1_Price,i+1);
      }
      
      if (MA2_Method == 4)
      {
        MA2_Cur = LSMA(Period2,i);
        MA2_Prev = LSMA(Period2,i+1);
      }
      else
      {
        MA2_Cur = iMA(NULL,0,Period2,0,MA2_Method,MA2_Price,i);
        MA2_Prev = iMA(NULL,0,Period2,0,MA2_Method,MA2_Price,i+1);
      }
 
         
//========== COLOR CODING ===========================================               
       /* */
       ExtMapBuffer3[i] = MA1_Cur; //red 
       ExtMapBuffer2[i] = MA1_Cur; //green
       ExtMapBuffer1[i] = MA1_Cur; //yellow
       ExtMapBuffer6[i] = MA2_Cur; //red 
       ExtMapBuffer5[i] = MA2_Cur; //green
       ExtMapBuffer4[i] = MA2_Cur; //yellow

       
        if (MA1_Prev > MA1_Cur)
        {
        ExtMapBuffer2[i] = EMPTY_VALUE;
        }
       else if (MA1_Prev < MA1_Cur) 
        {
        ExtMapBuffer1[i] = EMPTY_VALUE; //-1 red/greem tight
        }
         else 
         {
         ExtMapBuffer1[i]=EMPTY_VALUE;//EMPTY_VALUE;
         ExtMapBuffer2[i]=EMPTY_VALUE;//EMPTY_VALUE;
         } 
       
        if(High[i]>MA1_Cur&&Low[i]<MA1_Cur)
         {
         ExtMapBuffer1[i]=EMPTY_VALUE;//EMPTY_VALUE;
         ExtMapBuffer2[i]=EMPTY_VALUE;//EMPTY_VALUE;
         }
       
        if (MA2_Prev > MA2_Cur)
        {
        ExtMapBuffer5[i] = EMPTY_VALUE;
        }
       else if (MA2_Prev < MA2_Cur) 
        {
        ExtMapBuffer4[i] = EMPTY_VALUE; //-1 red/greem tight
        }
         else 
         {
         ExtMapBuffer4[i]=EMPTY_VALUE;//EMPTY_VALUE;
         ExtMapBuffer5[i]=EMPTY_VALUE;//EMPTY_VALUE;
         } 
       
        if(High[i]>MA2_Cur&&Low[i]<MA2_Cur)
         {
         ExtMapBuffer4[i]=EMPTY_VALUE;//EMPTY_VALUE;
         ExtMapBuffer5[i]=EMPTY_VALUE;//EMPTY_VALUE;
         }
        
        if(MA2_Prev<=MA1_Prev&&MA2_Cur>MA1_Cur&&Plot_Cross_VLines)
         {
         CreateVLine("CAPP_Cross"+(string)i,Time[i],Label_Short_Color,VLines_STYLE,VLines_Width,VLines_Back);
         } 
        
        if(MA2_Prev>=MA1_Prev&&MA2_Cur<MA1_Cur&&Plot_Cross_VLines)
         {
         CreateVLine("CAPP_Cross"+(string)i,Time[i],Label_Long_Color,VLines_STYLE,VLines_Width,VLines_Back);
         } 
      }
      
      if(Label_By_MAs&&!Label_By_Cloud_Color)
       {
      if(iMA(NULL,0,Period1,0,MA1_Method,MA1_Price,1)>iMA(NULL,0,Period2,0,MA2_Method,MA2_Price,1)&&Bid>iMA(NULL,0,Period1,0,MA1_Method,MA1_Price,1))
      {
      CreateLabel("CA&PP_Label_("+Period1+"/"+Period2+")","Long",Label_Long_Color);
      setGlobal(1);
      }
      
      else
      if(iMA(NULL,0,Period1,0,MA1_Method,MA1_Price,1)<iMA(NULL,0,Period2,0,MA2_Method,MA2_Price,1)&&Ask<iMA(NULL,0,Period1,0,MA1_Method,MA1_Price,1))
      {
      CreateLabel("CA&PP_Label_("+Period1+"/"+Period2+")","Short",Label_Short_Color);
      setGlobal(-1);
      }
      else
      {
      CreateLabel("CA&PP_Label_("+Period1+"/"+Period2+")","NoTrade",Label_NoTrade_Color);
      setGlobal(0);
      }
       }
       
      if(Label_By_Cloud_Color)
       {
      if(MA1_Buffer[1]>MA2_Buffer[1])
      {
      CreateLabel("CA&PP_Label_("+Period1+"/"+Period2+")","Long",Label_Long_Color);
      setGlobal(1);      
      }
      else
      if(MA1_Buffer[1]<MA2_Buffer[1])
      {
      CreateLabel("CA&PP_Label_("+Period1+"/"+Period2+")","Short",Label_Short_Color);
      setGlobal(-1);
      }
      else
      {
      CreateLabel("CA&PP_Label_("+Period1+"/"+Period2+")","NoTrade",Label_NoTrade_Color);
      setGlobal(0);      
      }
       }
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
double LSMA(int Rperiod, int shift)
{
   int i;
   double sum;
   int length;
   double lengthvar;
   double tmp;
   double wt;

   length = Rperiod;
 
   sum = 0;
   for(i = length; i >= 1  ; i--)
   {
     lengthvar = length + 1;
     lengthvar /= 3;
     tmp = 0;
     tmp = ( i - lengthvar)*Close[length-i+shift];
     sum+=tmp;
    }
    wt = sum*6/(length*(length+1));
    
    return(wt);
}
//+------------------------------------------------------------------+
void CreateLabel(string LabName, string txt, color Label_Color)
   {
  //ObjectDelete (0,LabName);
  if(ObjectFind(0,LabName)==-1)
  {
  ObjectCreate (LabName, OBJ_LABEL,Label_Window,0,0,0,0);
  ObjectSet    (LabName, OBJPROP_XDISTANCE, Label_X);
  ObjectSet    (LabName, OBJPROP_YDISTANCE, Label_Y);
  ObjectSet    (LabName, OBJPROP_SELECTABLE, false);
  ObjectSet    (LabName, OBJPROP_CORNER,Label_Corner);
  }
  ObjectSetText(LabName, txt, Label_Font_Size, Label_Font_Type, Label_Color);
   }  
//+------------------------------------------------------------------+
void CreateVLine(string name,datetime t,color c,int s,int w,bool b)
   { 
  if(ObjectFind(0,name)==-1)
  {
   ObjectCreate(0,name,OBJ_VLINE,0,t,0);
   ObjectSet(name,OBJPROP_STYLE,s);
   ObjectSet(name,OBJPROP_WIDTH,w);
   ObjectSet(name,OBJPROP_BACK,b);
   ObjectSet(name,OBJPROP_SELECTABLE,false);
   ObjectSet(name,OBJPROP_HIDDEN,true);
   }
   ObjectSet(name,OBJPROP_COLOR,c);
   } 
//+------------------------------------------------------------------+
bool IsNewBar()
 { 
  static datetime Trend_Candle_prevTime1 = -1;
  
  if(Trend_Candle_prevTime1 != Time[6])
  { 
   Trend_Candle_prevTime1 = Time[6]; 
       
   return(true);  
  } 

  return(false); 
 }
//+------------------------------------------------------------------+
void setGlobal (int trend)
{
if (save_globals)
GlobalVariableSet(global_name_capp_trend,trend);
}